unit MFMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SclRView, StdCtrls, ExtCtrls;

type
  TFMain = class(TForm)
    srve: TSRichViewEdit;
    pnl1: TPanel;
    btn1: TButton;
    btn2: TButton;
    PrintDialog1: TPrintDialog;
    procedure srvePaintPage(Sender: TObject; PageNo: Integer;
      PageRect, R: TRect; Canvas: TCanvas);
    procedure btn1Click(Sender: TObject);
    procedure btn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FMain: TFMain;

implementation

{$R *.DFM}

procedure TFMain.srvePaintPage(Sender: TObject; PageNo: Integer;
  PageRect, R: TRect; Canvas: TCanvas);
var
     H : Integer;
     Text: String;
begin
  Canvas.Brush.Style := bsSolid;
  Canvas.Brush.Color := clRed;
  Canvas.Font.Assign(srve.RichViewEdit.Style.TextStyles[0]);

  // Drawing header
  H := srve.TopMargin100Pix;
  Text := 'Page ' + IntToStr(PageNo);
  Canvas.FillRect(
    Rect(PageRect.Left, PageRect.Top, PageRect.Right, PageRect.Top + H));
  Canvas.TextOut(
    (PageRect.Left + PageRect.Right - Canvas.TextWidth(Text)) div 2,
    PageRect.Top+H div 2, Text);
  // Drawing footer
  H := srve.BottomMargin100Pix;
  Text := 'Sample Footer';
  Canvas.FillRect(
    Rect(PageRect.Left, PageRect.Bottom - H, PageRect.Right, PageRect.Bottom));
  Canvas.TextOut(
    (PageRect.Left + PageRect.Right - Canvas.TextWidth(Text)) div 2,
    PageRect.Bottom - H div 2, Text);
end;

procedure TFMain.btn1Click(Sender: TObject);
begin
  if (srve.ViewProperty.ViewMode = srvvmEditMode) then
    srve.ViewProperty.ViewMode := srvvmPreviewMode
  else
    srve.ViewProperty.ViewMode := srvvmEditMode;
end;

procedure TFMain.btn2Click(Sender: TObject);
begin
  if PrintDialog1.Execute then
    srve.PrintAll;
end;

end.
